%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  Begin Code %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%   OPTICAL FIBER   %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all, close all, clc;

tic
%% Define Parameters
global n m gamma Aeff Vref PLp P0s L...
       V lambda               %#ok<*GVMIS> 
   
   
C = 2.99792458e8;     % The Speed of Light (m/s)
gamma = 2;            % Polarization Factor
Aeff = 80e-12;        % Effective Fiber Cross Section (m^2)
Vref = 190e12;        % Reference Frequency (Hz)
% Fiber Length (km)
L = 1e3*input('Enter the Fiber Length(km): ');


%%%%%%%%% Pump Parameters %%%%%%%%
% Number of Pumps
n = input('Enter the Number of Pumps: ');
% Initial Power of Pumps (W)
PLp = 1e-3*input('Enter the Vector of Pumps Power(mW):\n\n')'; 
% Wavelength of Pumps (nm)
lp = input('\nEnter the Vector of Pumps Wavelength(nm):\n\n')';
% Frequency of Pumps (Hz)
Vp = (C./lp).*10^9;


%%%%%%%%% Signal Parameters %%%%%%%%           
% Number of Signals
m = input('\nEnter the Number of Signals: ');
% Initial Power of Signals (W)
P0s = 1e-3*input('Enter the Initial Power of Signals(mW): ');
% Starting Frequency Point of Signals
Vs_start = 1e12*input('Enter the Starting Frequency Point of Signals(THz): ');
% Distance Between the Signal Frequencies
step_size_Vs = 1e12*input('Enter the Distance Between Signal Frequencies(THz): ');
% Building the Signal Frequency Vector
for i=1:m
   % Frequency of Signals (Hz)
   Vs(i,1) = Vs_start+i*step_size_Vs;
   % Wavelength of signals (nm)
   ls(i,1) = (C./Vs(i,1)).*10^9;
end 
lambda = [lp;ls];     % Wavelength Vector (nm)  
V = [Vp;Vs];          % Frequency Vector (Hz)



%% Solve the Problem

% Display on the next 2-Lines
disp(' ')
disp(' ')
options=bvpset('Stats','on','RelTol',1e-5,'AbsTol',1e-5,'Nmax',1e3);
solinit = bvpinit(linspace(0,L,20), @Guess_lin);
sol = bvp4c(@EqFunc,@BcFunc,solinit,options);

t=sol.x./1000;
%%%%%%%%% Calculate the power of pums & signals %%%%%%%%
for i=1:m+n
    if i>=1 && i<=n
        Pp(i,:)=sol.y(i,:);
    end
    if i>=n+1 && i<=n+m
        Ps(i-n,:)=sol.y(i,:);
    end
end
Pp=Pp*1e3;  % Convert Pp from (W) to (mW)
Ps=Ps*1e3;  % Convert Ps from (W) to (mW)
%%%%%%%%% Calculate the Gain %%%%%%%%%
for k=1:m
    G(k)=10*log10((Ps(k,end))./Ps(k,1)); %#ok<*SAGROW>
end



%% Plotting Results

%%%%%%%%%%% plot the power of pums & signals %%%%%%%%%%%
figure(1)
for i=1:m+n
    subplot(121)
    if i>=1 && i<=n
        plot(t,Pp(i,:),'LineWidth',2)
        hold on
    end
    subplot(122)
    if i>=n+1 && i<=n+m
        plot(t,Ps(i-n,:),'LineWidth',2)
        hold on
    end
end
subplot(121)
xlabel('distance (km)')
xlim([t(1) t(end)]); grid on
ylabel('Power of pumps (mW)')
subplot(122)
xlabel('distance (km)')
xlim([t(1) t(end)]); grid on
ylabel('Power of signals (mW)')

%%%%%%%%% plot the Gain %%%%%%%%%
figure(2)
plot(ls,G,'Color',[200 50 50]/255,...
'Marker','s',...
'MarkerIndices',1:1:length(G),...
'LineStyle','--',...
'LineWidth',0.5,...
'MarkerSize',8,...
'MarkerEdgeColor','b',...
'MarkerFaceColor',[0.5,0.5,0.5])
xlabel('Signal Wavelength (nm)')
ylabel('Gain (dB)'); grid on
toc


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Code %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

